unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, MMObj, MMDSPObj, MMWave, MMCstDlg;

type
  TForm1 = class(TForm)
    SaveDialog: TMMWaveSaveDialog;
    OpenDialog: TMMWaveOpenDialog;
    SrcFile: TMMWaveFile;
    DestFile: TMMWaveFile;
    Button1: TButton;
    Label1: TLabel;
    procedure Button1Click(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
Label Again;
var
   Buffer: array[0..495] of Byte;
   idx: integer;
   nRead,nBytes,nDone: DWORD;
   FName: array[0..1] of string;
   DestName: string;

begin
   OpenDialog.Title := 'Select the first file';
   if not OpenDialog.Execute then exit;
   FName[0] := OpenDialog.FileName;

   OpenDialog.Title := 'Select the second file';
   if not OpenDialog.Execute then exit;
   FName[1] := OpenDialog.FileName;

   SaveDialog.Title := 'Select the destination file';
   if not SaveDialog.Execute then exit;
   DestName := SaveDialog.FileName;

   // delete the DestFile
   DeleteFile(DestName);

   idx := 0;
   SrcFile.Wave.FileName := FName[idx];

   // create the destiantion file
   DestFile.Wave.CreateFile(DestName, SrcFile.Wave.PWaveFormat);

Again:

   // open the source file
   SrcFile.Wave.OpenFile;

   nDone := 0;
   nBytes := SrcFile.Wave.DataSize;
   while nBytes > 0 do
   begin
      // read the data
      nRead := 4096;
      if nBytes < nRead then nRead := nBytes;
      nRead := SrcFile.Wave.ReadDataBytes(@Buffer, nRead);

      DestFile.Wave.WriteDataBytes(@Buffer, nRead);

      dec(nBytes,nRead);
      inc(nDone,nRead);

      Label1.Caption := IntToStr(nDone div (SrcFile.Wave.DataSize div 100)) + ' %';
      Label1.Update;
   end;

   SrcFile.Wave.CloseFile;

   inc(idx);
   if (idx = 1) then
   begin
      SrcFile.Wave.FileName := FName[idx];
      goto Again;
   end;

   DestFile.Wave.CloseFile;
end;

end.
